---
title: "Write DAX queries with Copilot | Microsoft Docs"
description: Use Copilot to create a DAX queries query. Type in a prompt to describe what DAX query you would like generated, and Copilot can create it.
ms.service: powerbi 
ms.date: 03/28/2024
ms.reviewer: 
ms.topic: how-to
author: maggieMSFT
ms.author: maggies
no-loc: [CoPilot]
#customer intent: As a DAX query writer, I want to use Copilot to help me write queries.
---
# Write DAX queries with Copilot

Try using Copilot to create a DAX query. Type in a prompt to describe what DAX query you would like generated and select **Send** or press <kbd>Enter</kbd>. To run what is returned, select **Keep it** to add it to query tab. Then select **Run** or press <kbd>F5</kbd> to see the results of the DAX query.  

## DAX query features in Copilot

Let’s look at what Copilot can help you with in [DAX query view](/power-bi/transform-model/dax-query-view): 

- **Natural language to DAX query**. Just ask for what you want from your semantic model and have the DAX query generated by Copilot.   
- **DAX query to natural language**. Ask Copilot to explain what any DAX query is doing. 
- **Understand DAX concepts**. Maybe you heard about a certain DAX function or need to find the right DAX function for the job. Copilot can help you here too.  

## Enable Copilot for DAX queries

In Power BI Desktop, in the **Preview features** section of the **Options**, enable **DAX query view with Copilot**.

Check to make sure you meet the [Fabric Copilot requirements](/fabric/get-started/copilot-fabric-overview#enable-copilot). 

Then navigate to the **DAX query view** and select the **Copilot** button or <kbd>CTRL+I</kbd> to launch the in-line Copilot.  

Let’s try some Copilot prompts, using sample data in Power BI Desktop, with some additional measures.  

## Sample prompts for writing DAX queries

Here is a collection of sample prompts to illustrate how to get Copilot to write the DAX queries you want.

- [List products and show the last three months' profit compared to the previous three months](#list-products-and-show-the-last-three-months-profit-compared-to-the-previous-three-months).
- [Add a column to show the difference](#add-a-column-to-show-the-difference).
- [Explain what this query does](#explain-what-this-query-does).
- [What is SUMMARIZECOLUMNS used for](#what-is-summarizecolumns-used-for).

### List products and show the last three months' profit compared to the previous three months

In a blank query tab, invoke Copilot with <kbd>CTRL+I</kbd> and enter this request:

"list the products and show the last 3 months profit compared to the 3 months before."

:::image type="content" source="media/dax-copilot/dax-list-products.png" alt-text="Screenshot showing list products and show last 3 months profit compared to the 3 months before." lightbox="media/dax-copilot/dax-list-products.png":::

After a few moments I get a detailed DAX query. 

:::image type="content" source="media/dax-copilot/dax-query-list-products.png" alt-text="Screenshot showing DAX query generated by Fabric Copilot." lightbox="media/dax-copilot/dax-query-list-products.png":::

I select **Keep it** and then **Run** the query. 

:::image type="content" source="media/dax-copilot/dax-copilot-updated-query.png" alt-text="Screenshot showing Run DAX query generated by Fabric Copilot." lightbox="media/dax-copilot/dax-copilot-updated-query.png":::  

Let's see the difference between the last three months and the previous three months. Select the query and start Copilot again with <kbd>CTRL+I</kbd>, or select the ribbon button. 

### Add a column to show the difference 

This time the selection is showing fitted to the text and the background shading highlights what is being sent with the request to Copilot. 

:::image type="content" source="media/dax-copilot/dax-copilot-show-diff.png" alt-text="Screenshot showing Run the query that calculated the profit." lightbox="media/dax-copilot/dax-copilot-show-diff.png":::

Now the diff styling in the DAX query editor shows exactly what Copilot has changed.  

:::image type="content" source="media/dax-copilot/dax-copilot-highlight-diff.png" alt-text="Screenshot showing Diff styling shows what Copilot has changed." lightbox="media/dax-copilot/dax-copilot-highlight-diff.png":::

I select **Keep it** and **Run** it again. 

:::image type="content" source="media/dax-copilot/dax-copilot-updated-query.png" alt-text="Screenshot showing Run the query and see the results, with the Profit Difference column." lightbox="media/dax-copilot/dax-copilot-updated-query.png":::

I see the DAX query, and I can see the requests I sent to Copilot at the top of the query. Each main block of the query is also commented, explaining what it’s doing in each part.

Maybe those comments aren't working for me. Let’s get a full explanation.  

### Explain what this query does 

Again, highlight the whole query and invoke Copilot with this request:

"Explain to me what this query does."

:::image type="content" source="media/dax-copilot/dax-copilot-explain-query.png" alt-text="Screenshot showing Explain to me what this query does." lightbox="media/dax-copilot/dax-copilot-explain-query.png":::

Now, instead of writing DAX queries, it’s responding in the in-line window.  

:::image type="content" source="media/dax-copilot/dax-copilot-query-explanation.png" alt-text="Screenshot showing brief explanation of the query.":::

Copilot generates a few lines. I select **Show more** to see the full explanation.

:::image type="content" source="media/dax-copilot/dax-copilot-explain-query-more.png" alt-text="Screenshot showing a long explanation of what the query does.":::

Now I understand each part and the DAX functions used.  

### What is SUMMARIZECOLUMNS used for?

Speaking of these DAX functions, it would be great to get an explanation of those too. Let’s try Copilot to  get some more information about a specific DAX function. 

 In this request, let’s find out what the SUMMARIZECOLUMNS does. 

:::image type="content" source="media/dax-copilot/dax-copilot-explain-summarize-columns.png" alt-text="Screenshot showing an explanation of what the SUMMARIZECOLUMNS does." lightbox="media/dax-copilot/dax-copilot-explain-summarize-columns.png":::

Again, Copilot generates brief description: 

:::image type="content" source="media/dax-copilot/dax-copilot-summarize-columns-brief.png" alt-text="Screenshot showing a brief description of the SUMMARIZECOLUMNS DAX funtion.":::

I select **Show more**. 

:::image type="content" source="media/dax-copilot/dax-copilot-summarize-columns-more.png" alt-text="Screenshot showing Copilot generates a much more in-depth description.":::

Because I asked Copilot in the context of a DAX query that I highlighted, it gave me the response in the context of that query as well.

## Learn more with these resources

- [Overview of Copilot in Fabric and Power BI](/fabric/get-started/copilot-fabric-overview#enable-copilot)
- [DAX query view](/power-bi/transform-model/dax-query-view) 
- [DAX queries](https://aka.ms/dax-queries)
